#!/usr/bin/env python
# Assign Colors To Resources.py
# Copyright 2005 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 060311 - First draft based on "Set the PlanBarColor" script

import wx
import re
import random

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

if debug: print 'Start Script'


def AssignColorsToResources(self):
    random.seed()
    colorDict = {
'Alizarin Crimson': 'E32636',
'Amber': 'FFBF00',
'Amethyst': '9966cc',
'Asparagus': '7BA05B',
'Aqua': '00FFFF',
'Aquamarine': '7fffd4',
'Azure': '007fff',
'Beige': 'F5F5DC',
'Bistre': '3D2B1F',
'Black': '000000',
'Blue': '0000ff',
'Bondi Blue': '0095B6',
'Brass': 'B5A642',
'Bright green': '66FF00',
'Bright turquoise': '08E8DE',
'Bright violet': 'CD00CD',
'Bronze': 'CD7F32',
'Brown': '964B00',
'Buff': 'F0DC82',
'Burgundy': '900020',
'Burnt Orange': 'cc5500',
'Burnt Sienna': 'E97451',
'Burnt umber': '8A3324',
'Camouflage green': '78866B',
'Cardinal': 'C41E3A',
'Carmine': '960018',
'Carrot': 'ED9121',
'Celadon': 'ACE1AF',
'Cerise': 'DE3163',
'Cerulean': '007BA7',
'Cerulean blue': '2A52BE',
'Chartreuse': '7fff00',
'Chestnut': 'CD5C5C',
'Chocolate': 'D2691E',
'Cinnamon': '7B3F00',
'Cobalt': '0047AB',
'Copper': 'b87333',
'Coral': 'ff7f50',
'Corn': 'FBEC5D',
'Cornflower blue': '6495ED',
'Cream': 'FFFDD0',
'Crimson': 'dc143c',
'Cyan': '00ffff',
'Dark brown': '654321',
'Dark cerulean': '08457E',
'Dark chestnut': '986960',
'Dark coral': 'CD5B45',
'Dark goldenrod': 'B8860B',
'Dark green': '013220',
'Dark Indigo': '310062',
'Dark Khaki': 'BDB76B',
'Dark Olive': '556832',
'Dark pastel green': '03C03C',
'Dark Peach': 'FFDAB9',
'Dark pink': 'E75480',
'Dark salmon': 'E9967A',
'Dark Scarlet': '560319',
'Dark slate gray': '2F4F4F',
'Dark spring green': '177245',
'Dark tan': '918151',
'Dark tangerine': 'FFA812',
'Dark Tea Green': 'BADBAD',
'Dark turquoise': '116062',
'Dark violet': '423189',
'Denim': '1560BD',
'Dodger blue': '1e90ff',
'Emerald': '50c878',
'Eggplant': '990066',
'Fern green': '4F7942',
'Flax': 'EEDC82',
'Fuchsia': 'f400a1',
'Gamboge': 'E49B0F',
'Gold': 'ffd700',
'Goldenrod': 'DAA520',
'Gray': '808080',
'Green': '00ff00',
'Heliotrope': 'DF73FF',
'Hot pink': 'FC0FC0',
'Indigo': '4B0082',
'International orange': 'FF4F00',
'Jade': '00A86B',
'Khaki': 'C3B091',
'Klein Blue': '002FA7',
'Lavender': 'BDBBD7',
'Lavender Blush': 'FFF0F5',
'Lemon': 'FDE910',
'Lemon Cream': 'FFFACD',
'Light brown': 'CD853F',
'Lilac': 'C8A2C8',
'Lime': 'CCFF00',
'Linen': 'FAF0E6',
'Magenta': 'FF00FF',
'Malachite': '0BDA51',
'Maroon': '800000',
'Mauve': '993366',
'Midnight Blue': '003366',
'Mint Green': '98FF98',
'Moss green': 'ADDFAD',
'Mountbatten pink': '997A8D',
'Mustard': 'FFDB58',
'Navajo white': 'FFDEAD',
'Navy blue': '000080',
'Ochre': 'CC7722',
'Old Gold': 'CFB53B',
'Olive': '808000',
'Olive Drab': '6B8E23',
'Orange': 'FFA500',
'Orchid': 'DA70D6',
'Pale Blue': 'AFEEEE',
'Pale brown': '987654',
'Pale carmine': 'AF4035',
'Pale chestnut': 'DDADAF',
'Pale cornflower blue': 'ABCDEF',
'Pale magenta': 'F984E5',
'Pale mauve': '996666',
'Pale pink': 'FADADD',
'Pale Sandy Brown': 'DABDAB',
'Pang': 'C7FCEC',
'Papaya whip': 'FFEFD5',
'Pastel green': '77DD77',
'Pastel pink': 'FFD1DC',
'Peach': 'FFE5B4',
'Pear': 'D1E231',
'Periwinkle': 'CCCCFF',
'Persian blue': '6600FF',
'Pine Green': '01796F',
'Pink': 'FFC0CB',
'Plum': '660066',
'Powder blue': '003399',
'Puce': 'CC8899',
'Prussian blue': '003153',
'Pumpkin': 'FF7518',
'Raw umber': '734A12',
'Red': 'FF0000',
'Robin egg blue': '00CCCC',
'Royal Blue': '4169E1',
'Russet': '755A57',
'Rust': 'B7410E',
'Saffron': 'F4C430',
'Sapphire': '082567',
'Salmon': 'FF8C69',
'Sandy brown': 'F4A460',
'Sangria': '92000A',
'Scarlet': 'FF2400',
'School bus yellow': 'ffd800',
'Sea Green': '2E8B57',
'Seashell': 'FFF5EE',
'Selective yellow': 'FFBA00',
'Sepia': '704214',
'Silver': 'C0C0C0',
'Slate gray': '708090',
'Spring Green': '00FF7F',
'Steel blue': '4682B4',
'Swamp green': 'ACB78E',
'Tan': 'D2B48C',
'Taupe': 'BC987E',
'Tangerine': 'FFCC00',
'Tea Green': 'D0F0C0',
'Teal': '008080',
'Thistle': 'D8BFD8',
'Turquoise': '30D5C8',
'Ultramarine': '120A8F',
'Vermilion': 'FF4D00',
'Violet': '8b00ff',
'Viridian': '40826D',
'Wheat': 'F5DEB3',
'Wisteria': 'C9A0DC',
'Zinnwaldite': 'EBC2AF',}
    colorArray = colorDict.keys()

    # set local pointers to tables
    rid = self.ReportID  # current report
    drep = Data.Database['Report']
    drow = Data.Database['ReportRow']
    dres = Data.Database['Resource']
    drt = Data.Database['ReportType']
    rr = drep[rid]

    # make sure report has report type
    if not rr.has_key('ReportTypeID') or not drt.has_key(rr['ReportTypeID']): 
        if debug: print "ReportType key not found"
        hint("Error: Can't find type of this report.")
        return
    rtid = rr['ReportTypeID']

    # is this a resource report
    rt = drt[rtid] # pointer to report type record
    ta = rt.get('TableA')
    tb = rt.get('TableB')  # if two table report all inserts go at the end (less confusing to user)
    if not (ta == 'Resource' or tb == 'Resource'):
        hint('Use script only with Resource reports.')
        return

    # find the selected rows
    sel = self.Report.GetSelectedRows()  # current selection
    if len(sel) <= 0:
        hint("Must select at least one resource row.")
        return

    rows = self.Report.table.rows
    # get row ids for all resource rows
    rids = [ drow[rows[x]].get('TableID') for x in sel 
        if drow[rows[x]].get('TableName') == 'Resource'
        and drow[rows[x]].get('TableID') ]
    if len(rids) < 1:
        hint("Must select at least one resource row.")
        return

# ----

#    if len(rids) == 1:  # one row selected
#        oldvalue = drow[rids[0]].get('PlanBarColor')
#        if not oldvalue or not re.match('^[0-9A-Fa-f]{6}$', oldvalue):
#            oldvalue = ""
#    else:
#        oldvalue = ""

    # change all selected rows to new color
    for rowid in rids:
        r = random.randint(0,len(colorArray)-1)

        name = colorArray.pop(r)  # this should remove the color from the array
        color = colorDict[name]
        if isinstance(color , basestring): color = color.upper()  # set to uppercase hex

        # may also want to remove all similar colors from the array???

        if dres[rowid].get('PlanBarColor') != color:
            change = { 'Table': 'Resource', 'ID': rowid, 'PlanBarColor': color, 'PlanBarColorName': name }
            Data.Update(change)

    Data.SetUndo('Assign Colors To Resources')

AssignColorsToResources(self)

if debug: print 'End Script'
